using System;
using System.IO;
using System.Runtime.InteropServices;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

      const int HORZRES = 8;

      [DllImport("user32.dll", CharSet=CharSet.Ansi)] private static extern IntPtr GetDC(IntPtr hWnd);
      [DllImport("gdi32.dll", CharSet=CharSet.Ansi)]  private static extern int    GetDeviceCaps(IntPtr hdc, int nIndex);
      [DllImport("user32.dll", CharSet=CharSet.Ansi)] private static extern int    ReleaseDC(IntPtr hWnd, IntPtr hdc);

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            int retval;
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetImportFlags(TImportFlags.ifImportAll | TImportFlags.ifImportAsPage); // The flag ifImportAsPage makes sure that pages will not be converted to templates.
            pdf.SetImportFlags2(TImportFlags2.if2UseProxy);                             // The flag if2UseProxy reduces the memory usage.

            if ((retval = pdf.OpenImportFile("../../../../../dynapdf_help.pdf.", TPwdType.ptOpen, null)) < 0)
            {
               if (pdf.IsWrongPwd(retval))
               {
                  Console.Write("File is encrypted!");
               }
               pdf = null;
               return;
            }
            // We must import an external page before we can render it
            pdf.Append();
               pdf.ImportPageEx(1, 1.0, 1.0);
            pdf.EndPage();
            pdf.CloseImportFile();

            // External cmaps should always be loaded when rendering PDF files.
            pdf.SetCMapDir(Path.GetFullPath("../../../../../Resource/CMap/"), TLoadCMapFlags.lcmRecursive | TLoadCMapFlags.lcmDelayed);
            // Initialize color management.  The default device profile is sRGB if no profile is set.
            TPDFColorProfiles p = new TPDFColorProfiles();
            p.StructSize = Marshal.SizeOf(p);
            p.DefInCMYKW = Path.GetFullPath("../../../../test_files/ISOcoated_v2_bas.ICC");
            pdf.InitColorManagement(p, TPDFColorSpace.csDeviceRGB, TPDFInitCMFlags.icmBPCompensation | TPDFInitCMFlags.icmCheckBlackPoint);

            IntPtr dc = GetDC(IntPtr.Zero);
            int     w = GetDeviceCaps(dc, HORZRES);
            ReleaseDC(IntPtr.Zero, dc);

            String filePath = Directory.GetCurrentDirectory() + "\\out.tif";
            if (pdf.RenderPageToImage(1, filePath, 0, w, 0, TRasterFlags.rfDefault, TPDFPixFormat.pxfRGB, TCompressionFilter.cfLZW, TImageFormat.ifmTIFF))
            {
               Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
               System.Diagnostics.Process pcs = new System.Diagnostics.Process();
               pcs.StartInfo.FileName = filePath;
               pcs.Start();
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
